import java.util.List;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Scanner;

public class Glavni {
    public static void main(String[] args) {
        Scanner skener = new Scanner(System.in);

        // Broj prodavnica
        int n = skener.nextInt();

        // Provera da li je broj prodavnica validan
        if (n < 4) {
            System.out.println("-1");
            return;
        }

        // Inicijalizacija grafa
        List<Integer>[] graf = new ArrayList[n + 1];
        for (int i = 0; i <= n; i++) {
            graf[i] = new ArrayList<>();
        }

        // Pocetne prodavnice 1, 2, 3 su povezane
        graf[1].add(2); graf[2].add(1);
        graf[1].add(3); graf[3].add(1);
        graf[2].add(3); graf[3].add(2);

        // Dodavanje veza za ostale prodavnice
        for (int i = 4; i <= n; i++) {
            int a = skener.nextInt();
            int b = skener.nextInt();
            int c = skener.nextInt();

            // Provera da li su indeksi validni
            if (a < 1 || a > n || b < 1 || b > n || c < 1 || c > n) {
                System.out.println("-1");
                return;
            }

            graf[i].add(a); graf[a].add(i);
            graf[i].add(b); graf[b].add(i);
            graf[i].add(c); graf[c].add(i);
        }

        // Inicijalizacija posecenih prodavnica i putanje
        boolean[] poseceno = new boolean[n + 1];
        List<Integer> putanja = new ArrayList<>();

        // Dodavanje prve prodavnice u putanju
        putanja.add(1);
        poseceno[1] = true;

        // Korišcenje steka za DFS
        Stack<Integer> stek = new Stack<>();
        stek.push(1);

        while (!stek.isEmpty()) {
            int trenutna = stek.pop();

            // Prolazak kroz sve susedne prodavnice
            for (int sused : graf[trenutna]) {
                if (!poseceno[sused]) {
                    putanja.add(sused);
                    poseceno[sused] = true;
                    stek.push(sused);
                }
            }
        }

        // Ako nije obavljena sve prodavnice, ispisujemo -1
        if (putanja.size() != n + 1) {
            System.out.println("-1");
            return;
        }

        // Dodavanje da se vrati na pocetak (prodavnica 1)
        putanja.add(1);

        // Ispis rezultata
        for (int prodavnica : putanja) {
            System.out.print(prodavnica + " ");
        }
    }
}