#include <iostream>
#include <vector>
#include <set>

using namespace std;

bool pronadjiPutanju(int trenutni, vector<vector<int>>& graf, vector<int>& putanja, vector<bool>& posecen, int n) 
{
    if (putanja.size() == n) 
    {
        for (int sused : graf[trenutni])
        {
            if (sused == 1) 
            {
                putanja.push_back(1);
                return true;
            }
        }
        return false;
    }

    for (int sused : graf[trenutni]) 
    {
        if (!posecen[sused]) 
        {
            posecen[sused] = true;
            putanja.push_back(sused);
            if (pronadjiPutanju(sused, graf, putanja, posecen, n)) 
            {
                return true;
            }

            posecen[sused] = false;
            putanja.pop_back();
        }
    }
    return false;
}

int main() 
{
    int n;
    cin >> n;
    if (n < 4) 
    {
        cout << -1 << endl;
        return 0;
    }
    vector<vector<int>> graf(n + 1);
    graf[1] = {2, 3, 4};
    graf[2] = {1, 3, 4};
    graf[3] = {1, 2, 4};
    graf[4] = {1, 2, 3};
    for (int x = 5; x <= n; ++x) 
    {
        int a, b, c;
        cin >> a >> b >> c;
        graf[x] = {a, b, c};
        graf[a].push_back(x);
        graf[b].push_back(x);
        graf[c].push_back(x);
    }

    vector<bool> posecen(n + 1, false);
    vector<int> putanja;

    posecen[1] = true;
    putanja.push_back(1);

    if (pronadjiPutanju(1, graf, putanja, posecen, n)) 
    {
        for (int cvor : putanja) 
        {
            cout << cvor << " ";
        }
        cout << endl;
    } 
    else 
    {
        cout << -1 << endl;
    }

    return 0;
}