#include "pch.h"

using namespace winrt;
using namespace Windows::Foundation;

//int main()
//{
//    init_apartment();
//    Uri uri(L"http://aka.ms/cppwinrt");
//    printf("Hello, %ls!\n", uri.AbsoluteUri().c_str());
//}
#include <iostream>
#include <vector>
#include <queue>
#include <stack>
#include <algorithm>
using namespace std;

struct Graph {
    vector<vector<int>> povezani;
    vector<bool> posecen;
    int br;

    Graph(int n) {
        br = n;
        posecen.resize(n, false);
        povezani.resize(n+1);
    }
    void dodaj(int u, int v) {
        povezani[u].push_back(v);
        povezani[v].push_back(u);
    }

    void DFS(int tr, vector<int> r, vector<bool> posetio, bool& kraj, int n) {
        if (kraj) return;
        r.push_back(tr);
        if (r.size() == n && find(povezani[tr].begin(), povezani[tr].end(), 1) != povezani[tr].end()) {
            for (int i = 0; i < n; i++) {
                cout << r[i] << " ";
            }
            cout << "1";
            kraj = true;
            return;
        }
        posetio[tr - 1] = true;

        bool er = true;
        for (auto komsija : povezani[tr]) {
            if (!posetio[komsija - 1]) {
                er = false;
                break;
            }
        }
        if (er)
            return;

        
        auto pored = povezani[tr];
        //std::reverse(pored.begin(), pored.end());
        for (auto komsija : pored) {
            if (!posetio[komsija - 1]) {
                DFS(komsija, r, posetio, kraj, n);
            }
        }
        return;
    }
};
int main()
{
    int n;
    cin >> n;
    vector<int> r;
    vector<bool> pos(n, false);
    bool kraj = false;
    Graph g(n);
    g.dodaj(1, 2);
    g.dodaj(2, 3);
    g.dodaj(1, 3);
    g.dodaj(1, 4);
    g.dodaj(2, 4);
    g.dodaj(3, 4);
    for (int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        g.dodaj(i, a);
        g.dodaj(i, b);
        g.dodaj(i, c);
    }
    g.DFS(1, r, pos, kraj, n);
    if (!kraj) {
        cout << "-1";
    }
    return 0;
}