#include <bits/stdc++.h>
using namespace std;
using ll = long long;

void printSolution(ll path[], vector<vector<bool>> graph)
{
    for (ll i = 0; i < graph.size(); i++)
        cout << path[i] + 1 << " ";

    cout << path[0] + 1 << " ";
    cout << endl;
}

bool isSafe(ll v, vector<vector<bool>> graph,
            ll path[], ll pos)
{
    if (graph[path[pos - 1]][v] == 0)
        return false;

    for (ll i = 0; i < pos; i++)
        if (path[i] == v)
            return false;

    return true;
}

bool hamCycleUtil(vector<vector<bool>> graph,
                  ll path[], ll pos)
{
    if (pos == graph.size())
    {
        if (graph[path[pos - 1]][path[0]] == 1)
            return true;
        else
            return false;
    }

    for (ll v = 1; v < graph.size(); v++)
    {
        if (isSafe(v, graph, path, pos))
        {
            path[pos] = v;

            if (hamCycleUtil(graph, path, pos + 1) == true)
                return true;

            path[pos] = -1;
        }
    }

    return false;
}

bool hamCycle(vector<vector<bool>> graph)
{
    ll *path = new ll[graph.size()];
    for (ll i = 0; i < graph.size(); i++)
        path[i] = -1;

    path[0] = 0;
    if (hamCycleUtil(graph, path, 1) == false)
    {
        cout << "-1";
        return false;
    }

    printSolution(path, graph);
    return true;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);
    ll n;
    cin >> n;
    vector<vector<ll>> v;
    for (ll I = 0; I < n - 4; I++)
    {
        vector<ll> temp(3);
        cin >> temp[0] >> temp[1] >> temp[2];
        v.push_back(temp);
    }

    vector<vector<bool>> graph(n);
    for (auto &a : graph)
    {
        a.resize(n);
    }
    graph[0][1] = 1;
    graph[1][0] = 1;
    graph[0][2] = 1;
    graph[2][0] = 1;
    graph[0][3] = 1;
    graph[3][0] = 1;
    graph[1][2] = 1;
    graph[2][1] = 1;
    graph[1][3] = 1;
    graph[3][1] = 1;
    graph[2][3] = 1;
    graph[3][2] = 1;
    for (ll i = 0; i < v.size(); i++)
    {
        graph[i + 4][v[i][0] - 1] = 1;
        graph[v[i][0] - 1][i + 4] = 1;
        graph[i + 4][v[i][1] - 1] = 1;
        graph[v[i][1] - 1][i + 4] = 1;
        graph[i + 4][v[i][2] - 1] = 1;
        graph[v[i][2] - 1][i + 4] = 1;
    }
    /*
    for (auto a : graph)
    {
        for (auto b : a)
        {
            cout << b << " ";
        }
        cout << "\n";
    }
    */
    hamCycle(graph);
}