using System;
using System.Linq;

namespace takmicenje
{
    class Program
    {
        static int izracunajProfit(int brojNft, int brojBrace, int[] vrednosti, int brat)
        {
            var matrica = new int[brojNft + 1, brojNft + 1];
            for (int i = 1; i <= brojNft; i++)
            {
                for (int pocetak = 0; pocetak + i <= brojNft; pocetak++)
                {
                    int kraj = pocetak + i - 1;
                    int trenutniBrat = (pocetak + (brojNft - kraj - 1)) % brojBrace;
                    int p = 0, q = 0;
                    if (trenutniBrat == brat)
                    {
                        if (pocetak + 1 <= kraj) p = matrica[pocetak + 1, kraj];
                        if (pocetak <= kraj - 1) q = matrica[pocetak, kraj - 1];
                        matrica[pocetak, kraj] = Math.Max(vrednosti[pocetak] + p, vrednosti[kraj] + q);
                    }
                    else
                    {
                        if (pocetak + 1 <= kraj) p = matrica[pocetak + 1, kraj];
                        if (pocetak <= kraj - 1) q = matrica[pocetak, kraj - 1];
                        matrica[pocetak, kraj] = Math.Min(p, q);
                    }
                }
            }
            return matrica[0, brojNft - 1];
        }
        static void Main(string[] args)
        {
            var unos = Console.ReadLine().Split();
            int brNft = int.Parse(unos[0]);
            int brojBrace = int.Parse(unos[1]);
            var vrednosti = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
            var profit = new int[brojBrace];
            for (int i = 0; i < brojBrace; i++) profit[i] = izracunajProfit(brNft, brojBrace, vrednosti, i);
            foreach(var nft in profit) Console.Write(nft + " ");
            Console.ReadLine();
        }
    }
}