#include <bits/stdc++.h>
using namespace std;

int n;
vector<unordered_map<int, bool>> graph;

vector<int> final_path;
//int prints = 0;
void solve(vector<int> path, unordered_map<int, bool> visited) {
    /*if(prints++ < 100) {
        for(int i = 0; i < path.size(); i++) {
            cout << path[i] << " ";
        }
        cout << endl;
    }*/
    int current = path.back();
    if(current == 1 && path.size() == n + 1) {
        final_path = path;
    } else {
        unordered_map<int, bool>& neighbors = graph[current];
        auto it = neighbors.begin();
        while(it != neighbors.end() && final_path.empty()) {
            int neighbor = it->first;
            if(visited.find(neighbor) == visited.end() || visited[neighbor] == false || neighbor == 1 && path.size() == n) {
                path.push_back(neighbor);
                visited[neighbor] = true;
                solve(path, visited);
                visited[neighbor] = false;
                path.pop_back();
            }
            it++;
        }
    }
}

int main() {
    cin >> n;
    graph.resize(n + 1);

    // init 1, 2, 3, 4 nodes
    for(int i = 1; i < 5; i++) {
        for(int j = 1; j < 5; j++) {
            if(i == j)
                continue;
            graph[i][j] = true;
        }
    }

    // init 5 ... n nodes
    for(int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        graph[i][a] = true;
        graph[i][b] = true;
        graph[i][c] = true;
        graph[a][i] = true;
        graph[b][i] = true;
        graph[c][i] = true;
    }

    /*cout << "GRAPH: " << endl;
    for(int i = 1; i <= n; i++) {
        cout << "VERTEX: " << i << " | NEIGHBORS: ";
        auto it = graph[i].begin();
        while(it != graph[i].end()) {
            cout << it->first << " ";
            it++;
        }
        cout << endl;
    }*/

    solve({1}, {{1, true}});

    if(!final_path.empty()) {
        for(int i = 0; i < final_path.size(); i++) {
            cout << final_path[i] << " ";
        }
        cout << endl;
    } else {
        cout << -1 << endl;
    }
}