#include <iostream>
#include <vector>

void cond_swap(int *a, int*b) {
    if (*a <= *b) return;
    int tmp = *a;
    *a = *b;
    *b = tmp;
}

struct Graph {
  std::vector<int> path;
  
  Graph() : path{0, 2, 3, 1} {}
  
  void add_node(int a, int b, int c) {
    cond_swap(&a, &b);
    cond_swap(&b, &c);
    cond_swap(&a, &b);
    if (divert(a,b)) return;
    if (divert(b,c)) return;
    if (divert(a,c)) return;

    std::cout << "-1";
  }
  bool divert(int x, int y) {
    int size = path.size();
    if (path[x] == y) {
      path[x] = size;
      path.push_back(y);
      return true;
    }
    if (path[y] == x) {
      path[y] = size;
      path.push_back(x);
      return true;
    }
    return false;
  }
  std::string get_path(void) {
      std::string p = "";
      int node = 1;
      int size = 1;
      do {
        p += std::to_string(node) + " ";
        node = path[node];
        ++size;
      } while (node != 1);
      if (size != path.size())
        return "-1";

      return p;
  }
};

int main(void) {
    struct Graph g; 
    int n;

    std::cin >> n;
    g.add_node(1, 2, 3); 
    for(int i = 5; i <= n; i++){
      int a, b, c;
      std::cin >> a >> b >> c;
      g.add_node(a, b, c);
    }
    
    std::cout << g.get_path() << "1" << std::endl;
}