#include <iostream>
#include <vector>
using namespace std;
bool hamiltonianPath(int v, const vector<vector<int>>& graph, vector<bool>& visited, vector<int>& path, int n) {
    visited[v] = true;
    path.push_back(v);
    if (path.size() == n) {
        return true;
    }
    for (int i = 1; i <= n; ++i) {
        if (graph[v][i] == 1 && !visited[i]) {
            if (hamiltonianPath(i, graph, visited, path, n)) {
                return true;
            }
        }
    }
    visited[v] = false;
    path.pop_back();
    return false;
}
int main() {
    int n;
    cin >> n;
    vector<vector<int>> graph(n + 1, vector<int>(n + 1, 0));
    graph[1][2] = graph[2][1] = 1;
    graph[1][3] = graph[3][1] = 1;
    graph[1][4] = graph[4][1] = 1;
    graph[2][3] = graph[3][2] = 1;
    graph[2][4] = graph[4][2] = 1;
    graph[3][4] = graph[4][3] = 1;
    for (int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        graph[i][a] = graph[a][i] = 1;
        graph[i][b] = graph[b][i] = 1;
        graph[i][c] = graph[c][i] = 1;
    }
    vector<int> path;
    vector<bool> visited(n + 1, false);
    if (hamiltonianPath(1, graph, visited, path, n)) {
        for (const int &res : path) {
            cout << res << ' ';
        }
        cout << 1;
    } else cout << -1;
    return 0;
}