#include <iostream>
#include <vector>
#include <stdio.h>
#include <cstring>
using namespace std;

#define Int64 int64_t

typedef std::vector<int> node;

bool* visited = nullptr;
bool inital = true;

bool DFS(const vector<node>& nodes, int start, std::vector<int>& visit_order)
{
	if (start == 0 && !inital)
	{
		if (visit_order.size() == nodes.size())
		{
			visited[start] = true;
			visit_order.push_back(start);
			return true;
		}
		return false;
	}
	inital = false;
	for (int i = 0; i < nodes[start].size(); ++i)
	{
		auto & nd = nodes[start];
		if (!visited[nd[i]])
		{
			visit_order.push_back(start);
			visited[nd[i]] = true;
			if (DFS(nodes, nd[i], visit_order))
			{
				return true;
			}
			visited[nd[i]] = false;
			visit_order.pop_back();
		}
	}
	return false;
}

int main()
{
	int n;
	cin >> n;
	visited = new bool[n];
	memset(visited,0,n);
	vector<node> nodes(n);
	// nodes.reserve(n);

	nodes[0].push_back(1);
	nodes[0].push_back(2);
	nodes[0].push_back(3);

	nodes[1].push_back(0);
	nodes[1].push_back(2);
	nodes[1].push_back(3);

	nodes[2].push_back(0);
	nodes[2].push_back(1);
	nodes[2].push_back(3);

	nodes[3].push_back(0);
	nodes[3].push_back(1);
	nodes[3].push_back(2);

	int to_input = n - 4;

	for (int i = 0; i < to_input; ++i)
	{
		int a, b, c;
		cin >> a;
		cin >> b;
		cin >> c;
		nodes[i + 4].push_back(a - 1);
		nodes[i + 4].push_back(b - 1);
		nodes[i + 4].push_back(c - 1);

		nodes[a - 1].push_back(i + 4);
		nodes[b - 1].push_back(i + 4);
		nodes[c - 1].push_back(i + 4);
	}

	vector<int> vec;
	bool rez = DFS(nodes,0,vec);

	for (int i : vec)
	{
		cout << i + 1 << " ";
	}
	cout << "\n";

	int a = 0;
}