#include <iostream>
#include <vector>
using namespace std;

bool isSafe(int v, const vector<vector<int>> &graph, vector<int> &path, int pos) {
    if (!graph[path[pos - 1]][v])
        return false;
    for (int i = 0; i < pos; i++) {
        if (path[i] == v)
            return false;
    }
    return true;
}

bool isHamiltonian(const vector<vector<int>> &graph, vector<int> &path, int pos) {
    if (pos == graph.size()) {
        return graph[path[pos - 1]][path[0]];
    }
    for (int v = 1; v < graph.size(); v++) {
        if (isSafe(v, graph, path, pos)) {
            path[pos] = v;
            if (isHamiltonian(graph, path, pos + 1))
                return true;
            path[pos] = -1;
        }
    }

    return false;
}

void hamiltonianCycle(const vector<vector<int>> &graph) {
    vector<int> path(graph.size(), -1);
    path[0] = 0;
    if (isHamiltonian(graph, path, 1)) {
        for (int v : path)
            cout << v + 1 << " ";
        cout << path[0] + 1 << endl;
    } else {
        cout << -1 << endl;
    }
}

int main() {
    int n;
    cin >> n;
    vector<vector<int>> graph(n, vector<int>(n, 0));
    for (int i = 0; i < 4; i++) {
        for (int j = 0; j < 4; j++) {
            if (i == j)
                continue;
            graph[i][j] = 1;
        }
    }
    for (int i = 0; i < n - 4; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        a--;
        b--;
        c--;
        graph[i + 4][a] = 1;
        graph[i + 4][b] = 1;
        graph[i + 4][c] = 1;
        graph[a][i + 4] = 1;
        graph[b][i + 4] = 1;
        graph[c][i + 4] = 1;
    }
    hamiltonianCycle(graph);
    return 0;
}