#include <iostream>
#include <vector>
using namespace std;

int main() {
    int n, m;
    cin >> n >> m;

    vector<int> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i];
    }

    vector<int> results(m, 0);
    for (int brother = 0; brother < m; brother++) {
        int left = 0, right = n - 1;
        int profit = 0;
        int turn = 0;

        while (left <= right) {
            if (turn == brother) {
                // This brother picks the maximum possible value
                if (a[left] >= a[right]) {
                    profit += a[left];
                    left++;
                } else {
                    profit += a[right];
                    right--;
                }
            } else {
                // Other brothers minimize this brother's profit
                if (a[left] >= a[right]) {
                    right--;
                } else {
                    left++;
                }
            }
            turn = (turn + 1) % m;
        }

        results[brother] = profit;
    }

    for (int i = 0; i < m; i++) {
        cout << results[i] << " ";
    }
    cout << endl;

    return 0;
}