#include <bits/stdc++.h>

using namespace std;

bool check_cycle(vector<vector<bool>> &graph, vector<int> &path,
                 vector<bool> &included, int cur) {
  if (cur == graph.size()) {
    if (graph[path[cur - 1]][path[0]]) {
      return true;
    }

    return false;
  }

  for (int i = 1; i < graph.size(); i++) {
    if (graph[path[cur - 1]][i] && !included[i]) {
      path[cur] = i;
      included[i] = true;

      if (check_cycle(graph, path, included, cur + 1)) {
        return true;
      }

      path[cur] = -1;
      included[i] = false;
    }
  }

  return false;
}

int main() {
  int n;
  cin >> n;
  vector<vector<bool>> graph(n, vector<bool>(n, false));
  for (int i = 0; i < 4; i++) {
    for (int j = 0; j < 4; j++) {
      graph[i][j] = true;
    }
  }

  int a, b, c;
  for (int i = 4; i < n; i++) {
    cin >> a >> b >> c;
    for (auto x : {a - 1, b - 1, c - 1}) {
      graph[i][x] = true;
      graph[x][i] = true;
    }
  }

  vector<int> path(n, -1);
  path[0] = 0;

  vector<bool> included(n, false);
  included[0] = true;

  if (!check_cycle(graph, path, included, 1)) {
    cout << "-1" << endl;
  } else {
    for (int i = 0; i < path.size(); i++) {
      cout << path[i] + 1 << " ";
    }

    cout << path[0] + 1 << endl;
  }

  return 0;
}