#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

bool HamPut(const vector<vector<int>>& graf, int trenutni, vector<bool>& posecen, vector<int>& put, int n) {
    posecen[trenutni] = true;
    put.push_back(trenutni);
    if (put.size() == n) {
        if (graf[trenutni][0] == 1) {
            return true;
        }
    }
    for (int neighbor : graf[trenutni]) {
        if (!posecen[neighbor]) {
            if (HamPut(graf, neighbor, posecen, put, n)) {
                return true;
            }
        }
    }
    posecen[trenutni] = false;
    put.pop_back();
    return false;
}

int main() {
    int n;
    cin >> n;
    vector<vector<int>> graf(n + 1);
    graf[1].push_back(2);
    graf[1].push_back(3);
    graf[2].push_back(1);
    graf[2].push_back(3);
    graf[3].push_back(1);
    graf[3].push_back(2);
    graf[4].push_back(1);
    graf[4].push_back(2);
    graf[4].push_back(3);
    for (int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        graf[i].push_back(a);
        graf[i].push_back(b);
        graf[i].push_back(c);
        graf[a].push_back(i);
        graf[b].push_back(i);
        graf[c].push_back(i);
    }
    vector<int> put;
    vector<bool> posecen(n + 1, false);
    if (HamPut(graf, 1, posecen, put, n)) {
        put.push_back(1);
        for (int i = 0; i < put.size(); i++) {
            cout << put[i] << " ";
        }
        cout << endl;
    }
    else {
        cout << -1 << endl;
    }
    return 0;
}