#include <iostream>
#include <vector>
using namespace std;

bool ima_suseda(vector<int> prodavnice){
    for(int prodavnica:prodavnice){
        if(prodavnica == 1){
            return true;
        }
    }
    return false;
}

bool pronadji_put(int trenutna_prodavnica, int n, vector<vector<int>>& prodavnice, vector<bool>& obidjena, vector<int>& putanja){
    putanja.push_back(trenutna_prodavnica);   //Dodavanje prodavnice u resenje
    obidjena[trenutna_prodavnica] = true;   

    if(putanja.size() == n){      //vaspitacica je obisla sve prodsvnice i spremna je da se vrati u pocetnu
        if(ima_suseda(prodavnice[trenutna_prodavnica])){    //povezano sa pocetnom?
            putanja.push_back(1);
            return true;
        }
        else{
            obidjena[trenutna_prodavnica] = false;
            putanja.pop_back();
            return false;
        }
    }

    for(int susedna_prodavnica:prodavnice[trenutna_prodavnica]){  //provera povezanih prodavnica redom
        if(!obidjena[susedna_prodavnica]){
            if(pronadji_put(susedna_prodavnica, n, prodavnice, obidjena, putanja)){
                return true;
            }
        }
    }

    obidjena[trenutna_prodavnica] = false;
    putanja.pop_back();

    return false;
}

int main(){
    int n;  //broj prodavnica 4 <= n <= 200000
    cin >> n;

    vector<vector<int>> prodavnice;
    vector<bool> obidjena;
    vector<int> putanja;

    prodavnice.resize(n + 1);
    obidjena.resize(n + 1, false);

    prodavnice[1] = {2, 3, 4};
    prodavnice[2] = {1, 3, 4};
    prodavnice[3] = {1, 2, 4};
    prodavnice[4] = {1, 2, 3};

    int a, b, c;
    for(int i = 5; i<=n; i++){
        cin >> a >> b >> c; //a=1 b=2 c=4 i=5

        prodavnice[i].push_back(a); 
        prodavnice[i].push_back(b);
        prodavnice[i].push_back(c); //{1,2,4}

        prodavnice[a].push_back(i); //{2,3,4,5}
        prodavnice[b].push_back(i); //{1,3,4,5}
        prodavnice[c].push_back(i); //{1,2,3,5}
    }

    if(pronadji_put(1, n, prodavnice, obidjena, putanja)){
        for(int resenje:putanja){
            cout << resenje << " ";
        }
    }
    else{
        cout << -1;
    }
    return 0;
}