#include<iostream>
#include<vector>
#include<algorithm>
using namespace std;

const int MAXN = 10005;
long long dp[MAXN][MAXN];
vector<int> nfts;
int N, M;


long long solve(int left, int right, int currentPlayer, int targetPlayer) {
    
    if(left>right)return 0;

    
    if(dp[left][right] !=-1)return dp[left][right];

    
    if(currentPlayer==targetPlayer) {
        dp[left][right]=max(
            nfts[left] + solve(left + 1, right, (currentPlayer + 1) % M, targetPlayer),
            nfts[right] + solve(left, right - 1, (currentPlayer + 1) % M, targetPlayer)
        );
    }
   
    else {
        dp[left][right] = min(
            solve(left + 1, right, (currentPlayer + 1) % M, targetPlayer),
            solve(left, right - 1, (currentPlayer + 1) % M, targetPlayer)
        );
    }

    return dp[left][right];
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    
    cin>>N>>M;
    nfts.resize(N);
    for (int i=0;i<N;i++) {
        cin >> nfts[i];
    }

    
    vector<long long>results(M);
    for (int player=0;player<M;player++){
        
        for (int i=0;i<N;i++){
            for (int j=0;j<N;j++){
                dp[i][j]=-1;
            }
        }
        
        results[player]=solve(0,N-1,0,player);
    }

    
    for(int i=0;i<M;i++){
        cout<<results[i];
        if (i<M-1)cout<< " ";
    }
    cout << endl;

    return 0;
}