#include<iostream>
#include<vector>
using namespace std;

vector<int> graph[200001];
vector<int> path;
bool visited[200001];

bool dfs(int current, int n, int count) {
    if (count == n) {
        if (find(graph[current].begin(), graph[current].end(), 1) != graph[current].end()) {
            path.push_back(1);
            return true;
        }
        return false;
    }


    for (int neighbor : graph[current]) {
        if (!visited[neighbor]) {
            visited[neighbor] = true;
            path.push_back(neighbor);
            if (dfs(neighbor, n, count + 1)) {
                return true;
            }
            path.pop_back();
            visited[neighbor] = false;
        }
    }
    return false;
}

int main() {
    int n;
    cin >> n;

   
    for (int i = 1; i <= 3; ++i) {
        for (int j = i + 1; j <= 3; ++j) {
            graph[i].push_back(j);
            graph[j].push_back(i);
        }
    }

   
    for (int i = 4; i <= n; ++i) {
        int a, b, c;
        cin >> a >> b >> c;
        graph[i].push_back(a);
        graph[i].push_back(b);
        graph[i].push_back(c);
        graph[a].push_back(i);
        graph[b].push_back(i);
        graph[c].push_back(i);
    }

 
    visited[1] = true;
    path.push_back(1);

   
    if (dfs(1, n, 1)) {
        for (int i : path) {
            cout << i << " ";
        }
        cout << endl;
    } else {
        cout << -1 << endl;
    }

    return 0;
}