#include<iostream>
#include<vector>
#include<set>
using namespace std;


vector<vector<int>>constructGraph(int n,const vector<vector<int>>&triangles)
{
    vector<vector<int>> graph(n+1);


    graph[1].push_back(2);graph[1].push_back(3);
    graph[2].push_back(1);graph[2].push_back(3);
    graph[3].push_back(1);graph[3].push_back(2);


    graph[4].push_back(1);graph[4].push_back(2);graph[4].push_back(3);
    graph[1].push_back(4);
    graph[2].push_back(4);
    graph[3].push_back(4);


    int currentStore=5;
    for(const auto&triangle:triangles)
{
        int a=triangle[0], b=triangle[1], c=triangle[2];
        graph[currentStore].push_back(a);
        graph[currentStore].push_back(b);
        graph[currentStore].push_back(c);
        graph[a].push_back(currentStore);
        graph[b].push_back(currentStore);
        graph[c].push_back(currentStore);
        currentStore++;
    }

    return graph;
}


bool findHamiltonianCycleDFS(const vector<vector<int>>&graph,vector<int>& path,
                            set<int>& visited, int current, int n, int start) {
    if (path.size()==n)
{

        for (int neighbor : graph[current]) {
            if (neighbor == start) {
                path.push_back(start);
                return true;
            }
        }
        return false;
    }

    for (int next : graph[current]) {
        if (visited.find(next) == visited.end()) {
            visited.insert(next);
            path.push_back(next);

            if (findHamiltonianCycleDFS(graph, path, visited, next, n, start)) {
                return true;
            }

            path.pop_back();
            visited.erase(next);
        }
    }
    return false;
}


vector<int>solve(int n,const vector<vector<int>>&triangles) {

    vector<vector<int>>graph=constructGraph(n,triangles);


    vector<int> path;
    set<int> visited;
    path.push_back(1);
    visited.insert(1);


    if (findHamiltonianCycleDFS(graph, path, visited, 1, n, 1)) {
        return path;
    }

       return vector<int>{-1};
}

int main() {
    int n;
    cin>>n;

    vector<vector<int>>triangles(n-4,vector<int>(3));
    for(int i=0;i<n-4;i++){
        cin>>triangles[i][0]>>triangles[i][1]>>triangles[i][2];
    }

    vector<int>result=solve(n,triangles);


    for(int i=0;i<result.size();i++){
        cout<<result[i];
        if(i<result.size()-1)cout<<" ";
    }
    cout<<endl;

    return 0;
}