#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    int N, M;
    cin >> N >> M;
    vector<int> a(N);
    
    for (int i = 0; i < N; ++i) {
        cin >> a[i];
    }

    vector<vector<int>> dp(N, vector<int>(N, 0));
    

    for (int len = 1; len <= N; ++len) {  
        for (int i = 0; i + len - 1 < N; ++i) {  
            int j = i + len - 1; 
            if (len == 1) {
                dp[i][j] = a[i];
            } else {
                dp[i][j] = max(a[i] - dp[i + 1][j], a[j] - dp[i][j - 1]);
            }
        }
    }

  
    vector<int> profits(M, 0);
    vector<bool> taken(N, false);
    int turn = 0;  

    while (true) {
        int left = 0, right = N - 1;
        while (left <= right && taken[left]) left++;
        while (left <= right && taken[right]) right--;

        if (left > right) break; 
        
        if (dp[left][right] == a[left] - dp[left + 1][right]) {
            profits[turn] += a[left];
            taken[left] = true;
        } else {
            profits[turn] += a[right];
            taken[right] = true;
        }

        turn = (turn + 1) % M;
    }


    sort(profits.rbegin(), profits.rend());

    for (int i = 0; i < M; ++i) {
        cout << profits[i] << " ";
    }
    cout << endl;

    return 0;
}