using System;
using System.Collections.Generic;
using System.Linq;
namespace ConsoleApp2
{
    internal class Program
    {
        public class HamiltonovCiklus
        {
            private int[,] graf;
            private int V;
            private List<int> putanja;

            public HamiltonovCiklus(int[,] matsusedstva)
            {
                graf = matsusedstva;
                V = graf.GetLength(0);
                putanja = new List<int>();
            }

            public void HamCiklus()
            {
                bool[] bio = new bool[V];
                NajduziHamiltonovCiklus(0, bio, 1, 0);
            }

            private void NajduziHamiltonovCiklus(int v, bool[] bio, int duzina, int start)
            {
                bio[v] = true;
                putanja.Add(v);

                for (int e = 0; e < V; e++)
                {
                    if (graf[v, e] == 1 && (!bio[e] || (e == start && duzina == V)))
                    {
                        if (e == start && duzina == V)
                        {
                            putanja.Add(start);
                            IspisiPut();
                            return;
                        }
                        else if (!bio[e])
                        {
                            NajduziHamiltonovCiklus(e, bio, duzina + 1, start);
                        }
                    }
                }

                bio[v] = false;
                putanja.RemoveAt(putanja.Count - 1);
            }

            private void IspisiPut()
            {
                foreach (var cvor in putanja)
                {
                    Console.Write(cvor+1 + " ");
                }
                Console.WriteLine();
            }
        }


        public static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            int[] pocetne = { 1, 2, 3, 4 };
            int[,] matsusedstva = new int[n, n];
            foreach (int x in pocetne)
            {
                for (int i = 0; i < 4; i++)
                {
                    if (i != x - 1)
                    {
                        matsusedstva[i, x - 1] = 1;
                        matsusedstva[x - 1, i] = 1;
                    }
                }
            }
            int p = 4;
            for (int i = 0; i < n - 4; i++)
            {
                string[] ss = Console.ReadLine().Split(" ");
                int a = int.Parse(ss[0]);
                int b = int.Parse(ss[1]);
                int c = int.Parse(ss[2]);
                matsusedstva[p, a - 1] = 1;
                matsusedstva[a - 1, p] = 1;
                matsusedstva[p, b - 1] = 1;
                matsusedstva[b - 1, p] = 1;
                matsusedstva[p, c - 1] = 1;
                matsusedstva[c - 1, p] = 1;
                p++;

            }
            HamiltonovCiklus ham = new HamiltonovCiklus(matsusedstva);
            ham.HamCiklus();
        }
    }

}