#include <bits/stdc++.h>
using namespace std;

bool dfs(int cvor, unordered_map<int, unordered_set<int>>& graf, vector<int>& put, unordered_set<int>& visited, int n) {
    put.push_back(cvor);
    if(put.size() == n){
        return graf[cvor].find(1) != graf[cvor].end();
    }

    visited.insert(cvor);
    for(int neighbor : graf[cvor]){
        if(visited.find(neighbor) == visited.end()){
            if(dfs(neighbor, graf, put, visited, n)){
                return true;
            }
        }
    }
    visited.erase(cvor);
    put.pop_back();
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;
    unordered_map<int, unordered_set<int>> graf;

    graf[1].insert(2);
    graf[1].insert(3);
    graf[1].insert(4);
    graf[2].insert(1);
    graf[2].insert(3);
    graf[2].insert(4);
    graf[3].insert(1);
    graf[3].insert(2);
    graf[3].insert(4);
    graf[4].insert(1);
    graf[4].insert(2);
    graf[4].insert(3);

    for(int i = 5; i <= n; i++){
        int a, b, c;
        cin >> a >> b >> c;
        graf[a].insert(i);
        graf[b].insert(i);
        graf[c].insert(i);
        graf[i].insert(a);
        graf[i].insert(b);
        graf[i].insert(c);
    }

    vector<int> put;
    unordered_set<int> visited;
    if(dfs(1, graf, put, visited, n)){
        for(int o : put){
            cout << o << " ";
        }
        cout << 1 << "\n";
    }
    else{
        cout << -1 << "\n";
    }

    return 0;
}