#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N, M;
    cin >> N >> M;

    vector<int> a(N);
    for (int i = 0; i < N; ++i) {
        cin >> a[i];
    }
    vector<vector<int>> dp(N, vector<int>(N, 0));
    for (int len = 1; len <= N; ++len) {
        for (int l = 0; l + len - 1 < N; ++l) {
            int r = l + len - 1;
            if (l == r) {
                dp[l][r] = a[l];
            } else {
                dp[l][r] = max(a[l] + min(dp[l + 2][r], dp[l + 1][r - 1]), 
                               a[r] + min(dp[l + 1][r - 1], dp[l][r - 2]));
            }
        }
    }

    vector<int> result(M, 0);
    int left = 0, right = N - 1;

    for (int i = 0; i < M; ++i) {
        if (i % 2 == 0) { 
            if (dp[left + 1][right] > dp[left][right - 1]) {
                result[i] = a[left];
                ++left;
            } else {
                result[i] = a[right];
                --right;
            }
        } else {
            if (dp[left + 1][right] > dp[left][right - 1]) {
                result[i] = a[left];
                ++left;
            } else {
                result[i] = a[right];
                --right;
            }
        }
    }
    for (int i = 0; i < M; ++i) {
        cout << result[i] << " ";
    }
    cout << endl;

    return 0;
}