#include <iostream>
#include <vector>
#include <unordered_set>
#include <unordered_map>

using namespace std;

void dfs(unordered_map<int, vector<int>>& points, unordered_set<int>& first, int n, int t, unordered_set<int>& visited, int p) {
    if(t == 0) {
        cout << "1 ";
        for (auto x : visited) {
            cout << x << " ";
        }
        cout << "1";
        exit(0);
    }
    visited.insert(p);
    for(int i = 0; i < points[p].size(); i++) {
        if(visited.find(points[p][i]) == visited.end() && points[p][i] != 1) {
            visited.insert(points[p][i]);
            dfs(points, first, n, t-1, visited, points[p][i]);
            visited.erase(points[p][i]);
        }
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    
    unordered_set<int> first;
    first.insert(1);
    first.insert(2);
    first.insert(3);
    unordered_map<int, vector<int>> points;
    points[1] = {2, 3};
    points[2] = {1, 3};
    points[3] = {1, 2};
    if(n >= 4) {
        points[4] = {1, 2, 3};
        points[1].push_back(4);
        points[2].push_back(4);
        points[3].push_back(4);
        first.insert(4);
    }
    for(int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        if(a == 1 || b == 1 || c == 1) first.insert(i);
        points[a].push_back(i);
        points[b].push_back(i);
        points[c].push_back(i);
        points[i] = {a, b, c};
    }
    unordered_set<int> visited;

    for(int i = 0; i < points[1].size(); i++) dfs(points, first, n, n-2, visited, points[1][i]);
    cout << "-1";

    return 0;
}