#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;
double minimaxRevenue(int start, int end, int currentBrother, int totalBrothers, vector<int>& nftValues, vector<vector<vector<int>>>& dp) {
    if (start > end) {
        return 0;
    }
    if (dp[start][end][currentBrother] != -1) {
        return dp[start][end][currentBrother];
    }
    int nextBrother = (currentBrother + 1) % totalBrothers;
    int takeStart = nftValues[start] + 
        minimaxRevenue(start + 1, end, nextBrother, totalBrothers, nftValues, dp);
    int takeEnd = nftValues[end] + 
        minimaxRevenue(start, end - 1, nextBrother, totalBrothers, nftValues, dp);
    if (currentBrother == 0) {
        dp[start][end][currentBrother] = min(takeStart, takeEnd);
    } else {
        dp[start][end][currentBrother] = max(takeStart, takeEnd);
    }
    return dp[start][end][currentBrother];
}

int main() {
    int N, M;
    cin >> N >> M;
    vector<int> nftValues(N);
    for (int i = 0; i < N; i++) {
        cin >> nftValues[i];
    }
    vector<vector<vector<int>>> dp(N, vector<vector<int>>(N, vector<int>(M, -1)));
    vector<int> revenues(M, 0);
    for (int i = 0; i < M; i++) {
        revenues[i] = minimaxRevenue(0, N - 1, i, M, nftValues, dp);
    }
    for (int i = 0; i < M; i++) {
        cout << revenues[i] << " ";
    }
    return 0;
}