#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>
using namespace std;
vector<vector<int>> adj;
vector<int> result;
void eulerTour(int node) {
    stack<int> st;
    st.push(node);

    while (!st.empty()) {
        int u = st.top();
        if (!adj[u].empty()) {
            int v = adj[u].back();
            adj[u].pop_back();
            st.push(v);
        } else {
            result.push_back(u);
            st.pop();
        }
    }
}
int main() {
    int n;
    cin >> n;
    adj.resize(n + 1);
    for (int x = 5; x <= n; ++x) {
        int a, b, c;
        cin >> a >> b >> c;
        adj[x].push_back(a);
        adj[x].push_back(b);
        adj[x].push_back(c);
        adj[a].push_back(x);
        adj[b].push_back(x);
        adj[c].push_back(x);
    }
    eulerTour(1);
    reverse(result.begin(), result.end());
    if (result.size() == n + 1 && result.front() == 1 && result.back() == 1) {
        for (int i : result) {
            cout << i << " ";
        }
        cout << endl;
    } else {
        cout << -1 << endl;
    }

    return 0;
}