#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_N 1000
#define MAX_M 10
#define INF 1000000000

int n, m;
int niz[MAX_N];
int dp[MAX_N][MAX_N][MAX_M];
int izracunato[MAX_N][MAX_N][MAX_M];
int resi(int l, int d, int igrac) {
    if (l > d) return 0;

    if (izracunato[l][d][igrac]) return dp[l][d][igrac];
    izracunato[l][d][igrac] = 1;

    if (igrac == 0) {
        int uzmi_levo = niz[l] + resi(l + 1, d, (igrac + 1) % m);
        int uzmi_desno = niz[d] + resi(l, d - 1, (igrac + 1) % m);
        dp[l][d][igrac] = (uzmi_levo > uzmi_desno) ? uzmi_levo : uzmi_desno;
    } else {
        int uzmi_levo = resi(l + 1, d, (igrac + 1) % m);
        int uzmi_desno = resi(l, d - 1, (igrac + 1) % m);
        dp[l][d][igrac] = (uzmi_levo < uzmi_desno) ? uzmi_levo : uzmi_desno;
    }

    return dp[l][d][igrac];
}

int main() {
    scanf("%d %d", &n, &m);
    for (int i = 0; i < n; i++) {
        scanf("%d", &niz[i]);
    }
    for (int i = 0; i < m; i++) {
        printf("%d", resi(0, n - 1, i));
        if (i < m - 1) {
            printf(" ");
        }
    }
    printf("\n");

    return 0;
}