#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdbool.h>

struct Graf {
    int brojCvorova;
    int **matricaPovezanosti;
};

struct Graf* napraviGraf(int brojCvorova) {
    struct Graf* graf = (struct Graf*)malloc(sizeof(struct Graf));
    graf->brojCvorova = brojCvorova;

    graf->matricaPovezanosti = (int**)malloc(brojCvorova * sizeof(int*));
    for (int i = 0; i < brojCvorova; i++) {
        graf->matricaPovezanosti[i] = (int*)malloc(brojCvorova * sizeof(int));
        for (int j = 0; j < brojCvorova; j++) {
            graf->matricaPovezanosti[i][j] = 0;
        }
    }

    return graf;
}

void dodajGranu(struct Graf* graf, int izvor, int odrediste) {
    graf->matricaPovezanosti[izvor][odrediste] = 1;
    graf->matricaPovezanosti[odrediste][izvor] = 1;
}

bool hamiltonovCiklusPomocna(struct Graf* graf, int* putanja, int pozicija) {
    if (pozicija == graf->brojCvorova) {
        return graf->matricaPovezanosti[putanja[pozicija - 1]][putanja[0]] == 1;
    }

    for (int v = 1; v < graf->brojCvorova; v++) {
        bool bezbedno = true;
        if (graf->matricaPovezanosti[putanja[pozicija - 1]][v] == 0) {
            bezbedno = false;
        }

        for (int i = 0; i < pozicija; i++) {
            if (putanja[i] == v) {
                bezbedno = false;
                break;
            }
        }

        if (bezbedno) {
            putanja[pozicija] = v;

            if (hamiltonovCiklusPomocna(graf, putanja, pozicija + 1)) {
                return true;
            }

            putanja[pozicija] = -1;
        }
    }

    return false;
}

void pronadjiHamiltonovCiklus(struct Graf* graf) {
    int* putanja = (int*)malloc(graf->brojCvorova * sizeof(int));
    for (int i = 0; i < graf->brojCvorova; i++) {
        putanja[i] = -1;
    }

    putanja[0] = 0;

    if (hamiltonovCiklusPomocna(graf, putanja, 1)) {
        for (int i = 0; i < graf->brojCvorova; i++) {
            printf("%d ", putanja[i] + 1);
        }
        printf("%d\n", putanja[0] + 1);
    } else {
        printf("-1\n");
    }

    free(putanja);
}

int main() {
    int brojCvorova;
    scanf("%d", &brojCvorova);
    struct Graf* graf = napraviGraf(brojCvorova);
    dodajGranu(graf, 0, 1);
    dodajGranu(graf, 0, 2);
    dodajGranu(graf, 0, 3);
    dodajGranu(graf, 1, 2);
    dodajGranu(graf, 1, 3);
    dodajGranu(graf, 2, 3);
    for (int i = 0; i < brojCvorova - 4; i++) {
        int a, b, c;
        scanf("%d%d%d", &a, &b, &c);
        dodajGranu(graf, a - 1, 4 + i);
        dodajGranu(graf, b - 1, 4 + i);
        dodajGranu(graf, c - 1, 4 + i);
    }
    pronadjiHamiltonovCiklus(graf);
}