#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>

using namespace std;

vector<vector<int>> graph;
vector<int> path;
vector<bool> visited;

bool dfs(int node, int n) {
    path.push_back(node);
    visited[node] = true;

    if (path.size() == n) {
        if (find(graph[node].begin(), graph[node].end(), 1) != graph[node].end()) {
            path.push_back(1);
            return true;
        }
    }

    for (int neighbor : graph[node]) {
        if (!visited[neighbor]) {
            if (dfs(neighbor, n)) {
                return true;
            }
        }
    }

    visited[node] = false;
    path.pop_back();
    return false;
}

int main() {
    int n;
    cin >> n;

    graph.resize(n + 1);
    visited.resize(n + 1, false);

    graph[1].push_back(2);
    graph[2].push_back(1);
    graph[1].push_back(3);
    graph[3].push_back(1);
    graph[2].push_back(3);
    graph[3].push_back(2);

    for (int i = 5; i <= n; ++i) {
        int a, b, c;
        cin >> a >> b >> c;
        graph[i].push_back(a);
        graph[a].push_back(i);
        graph[i].push_back(b);
        graph[b].push_back(i);
        graph[i].push_back(c);
        graph[c].push_back(i);
    }

    if (dfs(1, n)) {
        for (int i = 0; i < path.size(); ++i) {
            cout << path[i] << " ";
        }
    } else {
        cout << -1;
    }

    return 0;
}