#include <iostream>
#include <vector>
using namespace std;

void dfs(int cvor, vector<vector<int>> &graf, vector<bool> &poseceni, vector<int> &putanja) {
    poseceni[cvor] = true;
    putanja.push_back(cvor);
    for (int sused : graf[cvor]) {
        if (!poseceni[sused]) {
            dfs(sused, graf, poseceni, putanja);
        }
    }
}

int main() {
    int n;
    cout << "Unesite broj prodavnica: ";
    cin >> n;

    vector<vector<int>> graf(n + 1);
    graf[1] = {2, 3};
    graf[2] = {1, 3};
    graf[3] = {1, 2};

    for (int i = 4; i <= n; i++) {
        int a, b, c;
        cout << "Unesite trojku (3 broja): ";
        cin >> a >> b >> c;
        graf[i] = {a, b, c};
        graf[a].push_back(i);
        graf[b].push_back(i);
        graf[c].push_back(i);
    }

    vector<bool> poseceni(n + 1, false);
    vector<int> putanja;
    dfs(1, graf, poseceni, putanja);

    if (putanja.size() != n) {
        cout << -1 << endl;
    } else {
        putanja.push_back(1);
        for (int i = 0; i < putanja.size(); i++) {
            if (i > 0) cout << " ";
            cout << putanja[i];
        }
        cout << endl;
    }

    return 0;
}