#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#define MAXN 2000001

bool g[MAXN][MAXN];
bool v[MAXN];
int p[MAXN + 1];
int n, pi;

void spoj(int u, int v)
{
    g[u][v] = true;
    g[v][u] = true;
}
bool dfs(int a, int br)
{
    p[pi++] = a;
    v[a] = true;
    if (br == n)
    {
        if (g[a][1])
        {
            p[pi++] = 1;
            return true;
        }
        v[a] = false;
        pi--;
        return false;
    }
    for (int i = 1; i <= n; i++)
    {
        if (g[a][i] && !v[i])
        {
            if (dfs(i, br + 1))
            {
                return true;
            }
        }
    }
    v[a] = false;
    pi--;
    return false;
}
int main()
{
    scanf("%d", &n);
    for (int i = 1; i <= n; i++)
    {
        for (int j = 1; j <= n; j++)
        {
            g[i][j] = false;
        }
    }
    spoj(1, 2);
    spoj(2, 3);
    spoj(3, 1);
    spoj(4, 1);
    spoj(4, 2);
    spoj(4, 3);
    for (int i = 5; i <= n; i++)
    {
        int a, b, c;
        scanf("%d %d %d", &a, &b, &c);
        spoj(i, a);
        spoj(i, b);
        spoj(i, c);
    }
    pi = 0;
    if (dfs(1, 1))
    {
        for (int i = 0; i < pi; i++)
        {
            printf("%d ", p[i]);
        }
    }
    else
    {
        printf("-1");
    }
    return 0;
}