def maximize_profit(n, m, a):
    from functools import lru_cache

    # Rekurzivna funkcija s memoizacijom
    @lru_cache(None)
    def dp(left, right, player):
        if left > right:
            return 0  # Nema više elemenata

        # Ako je trenutni igrac "player", maksimizujemo njegov profit
        if player == 0:
            take_left = a[left] + dp(left + 1, right, (player + 1) % m)
            take_right = a[right] + dp(left, right - 1, (player + 1) % m)
            return max(take_left, take_right)
        else:
            # Ostali igraci minimizuju profit igraca "player"
            take_left = dp(left + 1, right, (player + 1) % m)
            take_right = dp(left, right - 1, (player + 1) % m)
            return min(take_left, take_right)

    # Rezultati za svakog igraca
    results = []
    for i in range(m):
        results.append(dp(0, n - 1, i))

    # Sortiranje rezultata
    return sorted(results, reverse = True)

# Ulaz
n, m = map(int, input().split())
a = list(map(int, input().split()))

# Izracunaj i ispiši rezultate
print(*maximize_profit(n, m, a))