#include <stdio.h>
#include <string.h>

#define MAX_N 100
#define MAX_M 10

int a[MAX_N];
int dp[MAX_N][MAX_N][MAX_M];

int solve(int l, int r, int turn, int M) {
    if (l > r) return 0;
    if (dp[l][r][turn] != -1) return dp[l][r][turn];

    if (turn == 0) {
        int take_left = a[l] + solve(l + 1, r, (turn + 1) % M, M);
        int take_right = a[r] + solve(l, r - 1, (turn + 1) % M, M);
        dp[l][r][turn] = take_left > take_right ? take_left : take_right;
    } else { 
        int take_left = solve(l + 1, r, (turn + 1) % M, M);
        int take_right = solve(l, r - 1, (turn + 1) % M, M);
        dp[l][r][turn] = take_left < take_right ? take_left : take_right;
    }

    return dp[l][r][turn];
}

int main() {
    int N, M;
    scanf("%d %d", &N, &M);

    for (int i = 0; i < N; i++) {
        scanf("%d", &a[i]);
    }

    
    for (int i = 0; i < M; i++) {
        memset(dp, -1, sizeof(dp));
        printf("%d ", solve(0, N - 1, i, M));
    }
    printf("\n");

    return 0;
}