#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAXN 100005

int n;
int graph[MAXN][3];  // ???? ???? ???? ?????????
int visited[MAXN];   // ??????????? ????????? ???????
int path[MAXN];      // ??????
int pathIndex = 0;

void dfs(int node) {
    // ???????? ???? ? ???
    path[pathIndex++] = node;
    visited[node] = 1;

    // ????? ???? ??? ???????? ??????? (?????????)
    for (int i = 0; i < 3; i++) {
        int neighbor = graph[node][i];
        if (!visited[neighbor]) {
            dfs(neighbor);
        }
    }
}

int main() {
    scanf("%d", &n);

    if (n < 4) {
        printf("-1\n");
        return 0;
    }

    // ????????? ???? ???? ?? 4. ?????????? ??????
    for (int i = 4; i <= n; i++) {
        int a, b, c;
        scanf("%d %d %d", &a, &b, &c);
        graph[i][0] = a;
        graph[i][1] = b;
        graph[i][2] = c;
    }

    // ????????? DFS ?? ????? 1
    dfs(1);

    // ??????? ?? ?? ?? ??? ??????? ???? ????????
    for (int i = 1; i <= n; i++) {
        if (!visited[i]) {
            printf("-1\n");
            return 0;
        }
    }

    // ?????????? ??????
    for (int i = 0; i < pathIndex; i++) {
        printf("%d ", path[i]);
    }
    printf("1\n");  // ??????? ?? ?? ??????? ?????????? 1

    return 0;
}