#include <bits/stdc++.h>

#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

#define ll long long
const int MAXN = 10001;

using namespace std;

int N, M;
int arr[MAXN];
ll dp[MAXN][MAXN];
int c_player;

ll solve(int L, int R) {
    if (L > R) return 0;
    
    if (dp[L][R] != -1) 
        return dp[L][R];
    
    int moves_made = N - (R - L + 1);
    int pos = moves_made % M;
    
    if (pos == c_player) {
        ll take_L = arr[L] + solve(L + 1, R);
        ll take_R = arr[R] + solve(L, R - 1);
        dp[L][R] = take_L > take_R ? take_L : take_R;
    } else {
        ll take_L = solve(L + 1, R);
        ll take_R = solve(L, R - 1);
        dp[L][R] = take_L < take_R ? take_L : take_R;
    }
    
    return dp[L][R];
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    
    cin >> N >> M;
    
    for (int i = 0; i < N; i++) {
        cin >> arr[i];
    }
    
    for (int i = 0; i < M; i++) {
        memset(dp, -1, sizeof(dp)); 
        c_player = i;
        ll result = solve(0, N-1);
        cout << result;
        cout << (i == M-1 ? '\n' : ' ');
    }
    
    return 0;
}