#include <bits/stdc++.h>

#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")


using namespace std;

#define ll long long

class Solve {
private:
    int n, m;
    vector<ll> vals;
    
    vector<ll> getMin(const vector<ll>& dp, int w) {
        vector<ll> mins(n + 1);
        deque<int> dq;
        
        for (int i = 1; i + w - 1 <= n; i++) {
            while (!dq.empty() && dp[dq.front()] > dp[i]) {
                dq.pop_front();
            }
            dq.push_front(i);
            
            if (dq.back() <= i - w) {
                dq.pop_back();
            }
            mins[i] = dp[dq.back()];
        }
        return mins;
    }
    
public:
    Solve(int n_, int m_, const vector<ll>& v) : n(n_), m(m_), vals(v) {}
    
    vector<ll> solve() {
        vector<ll> res(m + 1, LLONG_MAX);
        vector<ll> dp(n + 1);
        
        for (int mod = 1; mod <= m; mod++) {
            for (int i = 1; i + mod - 1 <= n; i++) {
                dp[i] = max(vals[i], vals[i + mod - 1]);
            }
            
            for (int len = mod + m; len <= n; len += m) {
                auto mins = getMin(dp, m);
                
                for (int i = 1; i + len - 1 <= n; i++) {
                    ll m1 = mins[i + m - 1];
                    ll m2 = mins[i + m];
                    dp[i] = max(vals[i] + m2, vals[i + len - 1] + m1);
                }
            }
            
            int finLen = ((n - mod) / m) * m + mod;
            int pos = n + 1 - finLen;
            
            for (int j = 1; j + finLen - 1 <= n; j++) {
                res[pos] = min(res[pos], dp[j]);
            }
        }
        
        return res;
    }
};

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);

    int n, m;
    cin >> n >> m;
    
    vector<ll> vals(n + 1);
    for (int i = 1; i <= n; i++) {
        cin >> vals[i];
    }
    
    Solve s(n, m, vals);
    vector<ll> res = s.solve();
    
    for (int i = 1; i <= m; i++) {
        cout << res[i] << " ";
    }
    
    return 0;
}