#include <bits/stdc++.h>

#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

using namespace std;

#define ll long long

typedef struct {
    int a, b, c;
} tri;

bool operator<(const tri& x, const tri& y) {
    return tie(x.a, x.b, x.c) < tie(y.a, y.b, y.c);
}

inline tri make_tri(tri x) {
    if(x.a > x.b) swap(x.a, x.b);
    if(x.a > x.c) swap(x.a, x.c);
    if(x.b > x.c) swap(x.b, x.c);
    return x;
}

set<tri> tris;
map<tri, int> inside;
int ham_path[200010], j = 0;

void add_tri(tri p, int i) {
    tris.erase(make_tri(p));
    tris.insert(make_tri({p.a,p.b,i}));
    tris.insert(make_tri({p.b,p.c,i}));
    tris.insert(make_tri({p.a,p.c,i}));
}

void solve_tri(tri t);

bool solve_tri_for_k(int a, int b, int c, int k) {
    if(tris.find(make_tri({b, c, k})) != tris.end()) {
        solve_tri({a, c, k});
        ham_path[j++] = k;
        solve_tri({a, b, k});
        return true;
    }
    return false;
}

void solve_tri(tri t) {
    t = make_tri(t);
    if(tris.find(t) != tris.end())
        return;
    int k = inside[t];
    solve_tri_for_k(t.a, t.b, t.c, k) ||
    solve_tri_for_k(t.b, t.c, t.a, k) ||
    solve_tri_for_k(t.c, t.a, t.b, k);
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    int n;
    cin >> n;
    inside[{1,2,3}] = 4;
    add_tri({1, 2, 3}, 4);
    for(int i=0;i<n-4;i++) {
        tri p;
        cin >> p.a >> p.b >> p.c;
        p = make_tri(p);
        inside[p] = i+5;
        add_tri(p, i+5);
    }
    ham_path[j++] = 1;
    solve_tri({1, 2, 3});
    for(int i=0;i<j;i++) cout << ham_path[i] << ' ';
    cout << "2 3 1\n";
    return 0;
}