using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp2
{
    class Program
    {
        static void Main()
        {
            Console.WriteLine("Unesite broj prodavnica (n):");
            string prvaLinija = Console.ReadLine();
            if (string.IsNullOrEmpty(prvaLinija))
            {
                throw new FormatException("Ulaz za broj prodavnica je prazan.");
            }

            int n = int.Parse(prvaLinija);

            int brojTrouglova = n - 4;
            if (brojTrouglova < 0)
            {
                Console.WriteLine("-1");
                return;
            }

            List<int>[] graf = new List<int>[n + 1];
            for (int i = 1; i <= n; i++)
            {
                graf[i] = new List<int>();
            }

            Console.WriteLine($"Unesite {brojTrouglova} trouglova (po tri broja odvojena razmakom):");
            for (int i = 0; i < brojTrouglova; i++)
            {
                string linija = Console.ReadLine();
                if (string.IsNullOrEmpty(linija))
                {
                    throw new FormatException($"Ulaz za trougao broj {i + 1} je prazan.");
                }

                string[] delovi = linija.Split();
                if (delovi.Length != 3)
                {
                    throw new FormatException($"Trougao broj {i + 1} mora da sadrži tacno tri celobrojne vrednosti.");
                }

                int a = int.Parse(delovi[0]);
                int b = int.Parse(delovi[1]);
                int c = int.Parse(delovi[2]);

                PoveziTrougao(graf, a, b, c);
            }

            List<int> putanja = new List<int>();
            bool[] posetio = new bool[n + 1];

            if (HamiltonovCiklus(graf, posetio, putanja, 1, n))
            {
                Console.WriteLine("Putanja kroz sve prodavnice:");
                Console.WriteLine(string.Join(" ", putanja));
            }
            else
            {
                Console.WriteLine("-1");
            }
        }

        static void PoveziTrougao(List<int>[] graf, int a, int b, int c)
        {
            graf[a].Add(b);
            graf[a].Add(c);
            graf[b].Add(a);
            graf[b].Add(c);
            graf[c].Add(a);
            graf[c].Add(b);
        }

        static bool HamiltonovCiklus(List<int>[] graf, bool[] posetio, List<int> putanja, int trenutni, int n)
        {
            putanja.Add(trenutni);
            posetio[trenutni] = true;

            if (putanja.Count == n && graf[trenutni].Contains(1))
            {
                putanja.Add(1);
                return true;
            }

            foreach (var sused in graf[trenutni])
            {
                if (!posetio[sused])
                {
                    if (HamiltonovCiklus(graf, posetio, putanja, sused, n))
                    {
                        return true;
                    }
                }
            }

            posetio[trenutni] = false;
            putanja.RemoveAt(putanja.Count - 1);
            return false;
        }
    }
}