using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<(int, int, int)> triangles = new List<(int, int, int)>();

        for (int i = 0; i < n - 4; i++)
        {
            string[] parts = Console.ReadLine().Split();
            int a = int.Parse(parts[0]);
            int b = int.Parse(parts[1]);
            int c = int.Parse(parts[2]);
            triangles.Add((a, b, c));
        }

        List<int> path = Solve(n, triangles);

        Console.WriteLine(string.Join(" ", path));
    }

    static List<int> Solve(int n, List<(int a, int b, int c)> triangles)
    {
        List<int>[] graph = new List<int>[n + 1];
        for (int i = 1; i <= n; i++)
        {
            graph[i] = new List<int>();
        }

        for (int i = 0; i < triangles.Count; i++)
        {
            var (a, b, c) = triangles[i];
            graph[a].Add(b);
            graph[a].Add(c);
            graph[b].Add(a);
            graph[b].Add(c);
            graph[c].Add(a);
            graph[c].Add(b);
        }

        for (int i = 1; i <= 4; i++)
        {
            for (int j = i + 1; j <= 4; j++)
            {
                graph[i].Add(j);
                graph[j].Add(i);
            }
        }

        bool[] visited = new bool[n + 1];
        List<int> path = new List<int>();

        void DFS(int node)
        {
            visited[node] = true;
            path.Add(node);

            foreach (int neighbor in graph[node])
            {
                if (!visited[neighbor])
                {
                    DFS(neighbor);
                }
            }
        }

        DFS(1);
        path.Add(1);

        return path;
    }
}