#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

const int N = 2e5 + 3;
set<pair<int, int>> adj[N];
vector<int> ans;
bool vis[N];
int dep[N];
int n;

void dfs(int u, int& cnt) {
    vis[u] = true;
    cnt++;

    if (cnt == n) {
        ans.push_back(u);
        return;
    }

    int poc = cnt;
    int t = -1;
    for (auto [dp, v] : adj[u]) {
        if (vis[v]) continue;
        dfs(v, cnt);
        if (cnt != n) {
            cnt = poc;
        } else {
            ans.push_back(u); return;
        }
    }
    if (t == -1) {
        vis[u] = false;
        cnt--;
    }

}

void solve() {
    cin >> n;

    adj[1].insert({0, 3});
    adj[3].insert({0, 1});
    adj[1].insert({0, 2});
    adj[2].insert({0, 1});
    adj[2].insert({0, 3});
    adj[3].insert({0, 2});

    auto povezi = [&](int u, int a, int b, int c) {
        dep[u] = min({dep[a], dep[b], dep[c]})-1;
        adj[u].insert({dep[a], a});
        adj[u].insert({dep[b], b});
        adj[u].insert({dep[c], c});

        adj[a].insert({dep[u], u});
        adj[b].insert({dep[u], u});
        adj[c].insert({dep[u], u});
    };

    povezi(4, 1, 2, 3);
    for (int i = 5; i <= n; i++) {
        int a, b, c; cin >> a >> b >> c;
        povezi(i, a, b, c);
    }
    int cnt = 0;
    dfs(1, cnt);
    reverse(ans.begin(), ans.end());
    ans.push_back(1);

    for (auto x : ans)
        cout << x << " ";
    cout << "\n";
}

signed main() {
    ios::sync_with_stdio(false); cin.tie(0);
	int t=1; //cin >> t;
	while (t--) {
        solve();
	}
}