#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>
using namespace std;

struct Graph {
    vector<vector<int>> adjacency_list;
    int br;
    Graph(int n)
    {
        br=n;
        adjacency_list.resize(n+1);
    }
    void add_edge(int u, int v) 
    {
        adjacency_list[u].push_back(v);
        adjacency_list[v].push_back(u);
    }
    void dfs(int start, int n) 
    {
        stack<pair<int, vector<int>>> st;
        st.push({start,{start}});
        vector<bool> visited;
        visited.resize(n+1, false);
        while (!st.empty()) 
        {
            auto [tr,put]=st.top();
            st.pop();
            if (put.size()==n && find(adjacency_list[tr].begin(), adjacency_list[tr].end(), 1)!=adjacency_list[tr].end())
            {
                for (auto chvor:put)
                {
                    printf("%d ",chvor);
                }
                printf("1\n");
                return;
            }
            visited[tr]=true;
            for (auto komsija:adjacency_list[tr]) 
            {
                if (!visited[komsija]) 
                {
                    vector<int> put1 = put;
                    put1.push_back(komsija);
                    st.push({komsija, put1});
                }
            }
        }
        printf("-1\n");
    }
};

int main() {
    int n;
    scanf("%d", &n);
    Graph g(n);
    g.add_edge(1,2);
    g.add_edge(1,3);
    g.add_edge(1,4);
    g.add_edge(2,3);
    g.add_edge(2,4);
    g.add_edge(3,4);
    for (int i=5;i<=n;i++) 
    {
        int a, b, c;
        scanf("%d %d %d", &a, &b, &c);
        g.add_edge(a,i);
        g.add_edge(b,i);
        g.add_edge(c,i);
    }
    g.dfs(1,n);
    return 0;
}