#include <iostream>
#include <climits>
#include <vector>
#include <algorithm>
using namespace std;

int MAKSIMIZUJ_PROFIT(int LEVO, int DESNO, int NA_RED, int IGRAC, int BROJ_BRACE, const vector<int>& NIZ, vector<vector<vector<int>>>& DP) {
    if (LEVO > DESNO) return 0;

    if (DP[LEVO][DESNO][NA_RED] != -1) return DP[LEVO][DESNO][NA_RED];

    if (NA_RED == IGRAC) {
        int UZMI_LEVO = NIZ[LEVO] + MAKSIMIZUJ_PROFIT(LEVO + 1, DESNO, (NA_RED + 1) % BROJ_BRACE, IGRAC, BROJ_BRACE, NIZ, DP);
        int UZMI_DESNO = NIZ[DESNO] + MAKSIMIZUJ_PROFIT(LEVO, DESNO - 1, (NA_RED + 1) % BROJ_BRACE, IGRAC, BROJ_BRACE, NIZ, DP);
        DP[LEVO][DESNO][NA_RED] = max(UZMI_LEVO, UZMI_DESNO);
    } else {
        int UZMI_LEVO = MAKSIMIZUJ_PROFIT(LEVO + 1, DESNO, (NA_RED + 1) % BROJ_BRACE, IGRAC, BROJ_BRACE, NIZ, DP);
        int UZMI_DESNO = MAKSIMIZUJ_PROFIT(LEVO, DESNO - 1, (NA_RED + 1) % BROJ_BRACE, IGRAC, BROJ_BRACE, NIZ, DP);
        DP[LEVO][DESNO][NA_RED] = min(UZMI_LEVO, UZMI_DESNO);
    }
    return DP[LEVO][DESNO][NA_RED];
}

int main() {
    int BROJ_NFT, BROJ_BRACE;
    cin >> BROJ_NFT >> BROJ_BRACE;

    vector<int> NIZ(BROJ_NFT);
    for (int e = 0; e < BROJ_NFT; e++) {
        cin >> NIZ[e];
    }

    vector<int> REZULTATI(BROJ_BRACE, 0);

    for (int IGRAC = 0; IGRAC < BROJ_BRACE; ++IGRAC) {
        vector<vector<vector<int>>> DP(BROJ_NFT, vector<vector<int>>(BROJ_NFT, vector<int>(BROJ_BRACE, -1)));
        REZULTATI[IGRAC] = MAKSIMIZUJ_PROFIT(0, BROJ_NFT - 1, 0, IGRAC, BROJ_BRACE, NIZ, DP);
    }

    for (int q = 0; q < BROJ_BRACE; q++) {
        cout << REZULTATI[q] << " ";
    }

    return 0;
}