using System;

class Program
{
    static void Main()
    {
        // Ucitavanje broja NFT-ova i broja brace
        var input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int M = int.Parse(input[1]);

        // Ucitavanje vrednosti NFT-ova
        var a = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

        // Rezultati profita za svakog brata
        long[] profits = new long[M];

        // Dinamicko programiranje za izracunavanje profita
        long[,] dp = new long[N + 1, N + 1];

        // Popunjavanje DP tabele
        for (int length = 1; length <= N; length++)
        {
            for (int left = 0; left + length - 1 < N; left++)
            {
                int right = left + length - 1;
                // Ako uzmemo levo
                long takeLeft = a[left] + (length > 1 ? Math.Min(dp[left + 1, right], dp[left, right - 1]) : 0);
                // Ako uzmemo desno
                long takeRight = a[right] + (length > 1 ? Math.Min(dp[left + 1, right], dp[left, right - 1]) : 0);
                dp[left, right] = Math.Max(takeLeft, takeRight);
            }
        }

        // Izracunavanje profita za svakog brata
        for (int i = 0; i < M; i++)
        {
            profits[i] = dp[0, N - 1];
            // Uklanjamo jedan NFT iz niza
            if (N > 0)
            {
                // Uzimamo prvi ili poslednji NFT
                long takeLeft = a[0];
                long takeRight = a[N - 1];

                // Ažuriramo niz
                if (takeLeft >= takeRight)
                {
                    // Uzimamo levo
                    a[0] = 0; // Uklanjamo ga
                    N--;
                }
                else
                {
                    // Uzimamo desno
                    a[N - 1] = 0; // Uklanjamo ga
                    N--;
                }
            }
        }

        // Ispis rezultata
        Console.WriteLine(string.Join(" ", profits));
    }
}