using System;
using System.Collections.Generic;

class Program
{
    static List<int>[] graph;
    static bool[] visited;
    static List<int> path;

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        graph = new List<int>[n + 1];
        for (int i = 1; i <= n; i++)
        {
            graph[i] = new List<int>();
        }

        // Ucitavanje podataka o trojicama
        for (int i = 4; i <= n; i++)
        {
            var line = Console.ReadLine().Split();
            int a = int.Parse(line[0]);
            int b = int.Parse(line[1]);
            int c = int.Parse(line[2]);

            // Povezivanje prodavnica
            graph[i].Add(a);
            graph[i].Add(b);
            graph[i].Add(c);
            graph[a].Add(i);
            graph[b].Add(i);
            graph[c].Add(i);
        }

        visited = new bool[n + 1];
        path = new List<int>();

        // Pocetak pretrage
        visited[1] = true;
        path.Add(1);
        if (FindHamiltonianPath(1, n))
        {
            path.Add(1); // Vracamo se na pocetnu prodavnicu
            Console.WriteLine(string.Join(" ", path));
        }
        else
        {
            Console.WriteLine(-1);
        }
    }

    static bool FindHamiltonianPath(int current, int remaining)
    {
        if (path.Count == remaining + 1) // Ako smo posetili sve prodavnice
        {
            return true;
        }

        foreach (var neighbor in graph[current])
        {
            if (!visited[neighbor])
            {
                visited[neighbor] = true;
                path.Add(neighbor);

                if (FindHamiltonianPath(neighbor, remaining))
                {
                    return true;
                }

                // Backtrack
                visited[neighbor] = false;
                path.RemoveAt(path.Count - 1);
            }
        }

        return false;
    }
}