using System;
namespace SecondQual
{
    class Programme
    {
        public static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<int>[] graph = new List<int>[n + 1];
            for (int i = 1; i <= n; i++)
            {
                graph[i] = new List<int>();
            }
            graph[1].Add(2);
            graph[1].Add(3);
            graph[2].Add(1);
            graph[2].Add(3);
            graph[3].Add(1);
            graph[3].Add(2);
            graph[4].Add(1);
            graph[4].Add(2);
            graph[4].Add(3);
            graph[1].Add(4);
            graph[2].Add(4);
            graph[3].Add(4);
            for (int i = 5; i <= n; i++)
            {
                string[] input = Console.ReadLine().Split();
                int a = int.Parse(input[0]);
                int b = int.Parse(input[1]);
                int c = int.Parse(input[2]);
                graph[i].Add(a);
                graph[i].Add(b);
                graph[i].Add(c);
                graph[a].Add(i);
                graph[b].Add(i);
                graph[c].Add(i);
            }
            List<int> path = new List<int>();
            bool[] visited = new bool[n + 1];
            bool foundPath = FindHamiltonianPath(graph, 1, path, visited, n);

            if (foundPath)
            {
                path.Add(1);
                Console.WriteLine(string.Join(" ", path));
            }
            else
            {
                Console.WriteLine(-1);
            }
        }
        static bool FindHamiltonianPath(List<int>[] graph, int current, List<int> path, bool[] visited, int totalNodes)
        {
            path.Add(current);
            visited[current] = true;

            if (path.Count == totalNodes)
            {
                return true;
            }
            foreach (int neighbor in graph[current])
            {
                if (!visited[neighbor])
                {
                    if (FindHamiltonianPath(graph, neighbor, path, visited, totalNodes))
                    {
                        return true;
                    }
                }
            }
            path.RemoveAt(path.Count - 1);
            visited[current] = false;
            return false;
        }
    }
}