using System;
using System.Collections.Generic;
internal class Program
{
    public class Graf
    {
        private Dictionary<int, List<int>> susedni;
        public Graf()
        {
            susedni = new Dictionary<int, List<int>>();
        }
        public void Dodaj(int x, int y)
        {
            if (!susedni.ContainsKey(x))
            {
                susedni[x] = new List<int>();
            }
            if (!susedni.ContainsKey(y))
            {
                susedni[y] = new List<int>();
            }
            susedni[x].Add(y);
            susedni[y].Add(x);
        }
        public void Put()
        {
            int[] put = new int[susedni.Count];
            Array.Fill(put, -1);
            put[0] = 1;
            if (ImaPut(put, 1))
            {
                foreach (int cvor in put)
                {
                    Console.Write(cvor + " ");
                }

                Console.Write(1);
            }
            else
            {
                Console.WriteLine(-1);
            }
        }
        public bool ImaPut(int[] put, int pozicija)
        {
            if (pozicija == put.Length)
            {
                return susedni[put[pozicija - 1]].Contains(put[0]);
            }
            for (int i = 0; i < susedni[put[pozicija - 1]].Count; i++)
            {
                int sused = susedni[put[pozicija - 1]][i];
                if (Array.IndexOf(put, sused, 0, pozicija) == -1)
                {
                    put[pozicija] = sused;
                    if (ImaPut(put, pozicija + 1))
                    {
                        return true;
                    }
                    put[pozicija] = -1;
                }
            }
            return false;
        }
    }
    static void Main(string[] args)
    {
        Graf graf = new Graf();
        int n = int.Parse(Console.ReadLine());
        graf.Dodaj(1, 2);
        graf.Dodaj(1, 3);
        graf.Dodaj(2, 3);
        graf.Dodaj(4, 1);
        graf.Dodaj(4, 2);
        graf.Dodaj(4, 3);
        
        for (int i = 5; i <= n; i++)
        {
            string[] input = Console.ReadLine().Split(" ");
            int x = int.Parse(input[0]);
            int y = int.Parse(input[1]);
            int z = int.Parse(input[2]);
            graf.Dodaj(i, x);
            graf.Dodaj(i, y);
            graf.Dodaj(i, z);
        }
        graf.Put();
    }
}