#include <bits/stdc++.h>

bool hamil(const std::vector<std::vector<int>>& graf, std::vector<int>& put, std::vector<bool>& poseceno, int p)
{
    if(p == graf.size())
        return true;

    for(int i = 1; i < graf.size(); i++)
    {
        if(std::find(graf[put[p - 1]].begin(), graf[put[p - 1]].end(), i) == graf[put[p - 1]].end() || poseceno[i])
            continue;
        
        put[p] = i;
        poseceno[i] = true;

        if(hamil(graf, put, poseceno, p + 1))
            return true;

        put[p] = -1;
        poseceno[i] = false;
    }

    return false;
}

int main()
{
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int N;
    std::cin >> N;

    std::vector<std::vector<int>> graf(N + 1);
    std::vector<int> put(N + 1, -1);
    std::vector<bool> poseceno(N + 1, false);
    put[1] = 1;
    poseceno[1] = true;

    for(int i = 1; i <= 4; i++)
        for(int j = 1; j <= 4; j++)
            if(i != j)
                graf[i].push_back(j);
    
    for(int i = 5; i <= N; i++)
    {
        int n[3];
        std::cin >> n[0] >> n[1] >> n[2];
        for(int x : n)
        {
            graf[i].push_back(x);
            graf[x].push_back(i);
        }
    }

    if(!hamil(graf, put, poseceno, 2))
    {
        std::cout << -1;
        return 0;
    }

    for(int i = 1; i <= N; i++)
        std::cout << put[i] << " ";
    std::cout << "1\n";

    return 0;
}