#include <iostream>
#include <vector>
#include <stack>
#include <unordered_set>

using namespace std;

class Graph {
public:
    int N;
    vector<vector<int>> lista;
    unordered_set<int> poseceni;

    Graph(int n) {
        N = n;
        lista.resize(n);
    }

    void dodaj(int u, int v) {
        lista[u].push_back(v);
        lista[v].push_back(u);
    }

    void DFS(int *a, int cvor, int n) {
        bool ok = false;
        bool da = false;
        stack<int> s;
        s.push(cvor);
        poseceni.insert(cvor);

        while (!s.empty() && !ok) {
            int c = s.top();
            int c1 = c;
            int c2 = 0;
            da = false;
            ok = false;

            while (!da) {
                for (int sused : lista[c]) {
                    if (sused > c2 && poseceni.find(sused) == poseceni.end()) {
                        poseceni.insert(sused);
                        s.push(sused);
                        da = true;
                        break;
                    }
                }

                if (poseceni.size() == n && find(lista[c].begin(), lista[c].end(), 0) != lista[c].end()) {
                    ok = true;
                }

                if (!da) {
                    s.pop();
                    c = s.top();
                    poseceni.erase(c1);
                    c2 = c1;
                    c1 = c;
                }
            }
        }

        int stack_size = s.size();
        a[stack_size] = 1;
        for (int i = stack_size; i > 0; --i) {
            a[i] = s.top() + 1;
            s.pop();
        }
    }
};

int main() {
    int n;
    cin >> n;

    Graph g(n);
    g.dodaj(0, 1);
    g.dodaj(1, 2);
    g.dodaj(0, 2);
    g.dodaj(0, 3);
    g.dodaj(1, 3);
    g.dodaj(2, 3);

    for (int i = 0; i < n - 4; ++i) {
        int u, v, w;
        cin >> u >> v >> w;
        g.dodaj(4 + i, u);
        g.dodaj(4 + i, v);
        g.dodaj(4 + i, w);
    }

    int *a = new int[n + 1];
    g.DFS(a, 0, n);

    for (int i = 0; i < n - 1; ++i) {
        cout << a[i] + 1 << " ";
    }
    cout << a[n] << endl;

    delete[] a;
    return 0;
}