#include <bits/stdc++.h>
using namespace std;

int N;

namespace case1 // N <= 10
{
  void solve()
  {
    bool adj[20][20];

    memset(adj, false, sizeof(adj));

    auto povezi = [&](int u, int v)
    {
      adj[u][v] = true;
      adj[v][u] = true;
    };

    povezi(1, 2);
    povezi(2, 3);
    povezi(3, 1);

    povezi(4, 1);
    povezi(4, 2);
    povezi(4, 3);

    for (int x = 5; x <= N; x++)
    {
      int a, b, c;
      cin >> a >> b >> c;
      povezi(x, a);
      povezi(x, b);
      povezi(x, c);
    }

    vector<int> perm;
    for (int v = 2; v <= N; v++)
    {
      perm.push_back(v);
    }

    bool found = false;
    vector<int> cycle;

    do
    {
      if (!adj[1][perm[0]])
        continue;

      bool good = true;
      for (int i = 0; i < (int)perm.size() - 1; i++)
      {
        if (!adj[perm[i]][perm[i + 1]])
        {
          good = false;
          break;
        }
      }

      if (good)
      {
        if (!adj[perm.back()][1])
        {
          good = false;
        }
      }

      if (good)
      {
        found = true;
        cycle.clear();
        cycle.push_back(1);
        for (int i : perm)
        {
          cycle.push_back(i);
        }
        cycle.push_back(1);
        break;
      }

    } while (next_permutation(perm.begin(), perm.end()));

    if (!found)
    {
      cout << -1 << "\n";
    }
    else
    {
      for (int i : cycle)
      {
        cout << i << " ";
      }
      cout << "\n";
    }
  }
}

namespace case2 // 1, 2, x-1
{
  void solve()
  {
    for (int i = 1; i <= N; i++)
    {
      cout << i << " ";
    }
    cout << "1\n";
  }
}

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N;

  if (N <= 13)
  {
    case1::solve();
  }
  else
  {
    case2::solve();
  }

  return 0;
}