#include <iostream>
#include <climits>

using namespace std;

const int MAX_SIZE = 1e4 + 10;

int velicinaNiza, vrednostModula;
int vrednosti[MAX_SIZE], minimalneVrednosti[MAX_SIZE];
int trenutniDp[MAX_SIZE];
int red[MAX_SIZE+1];
int pocetakReda, krajReda;
int rezultati[MAX_SIZE];

inline void ocistiRed() {
    pocetakReda = krajReda = 0;
}

inline int uzmiIzReda(bool prvi = true) {
    return red[prvi ? pocetakReda : ((krajReda + MAX_SIZE) % (MAX_SIZE + 1))];
}

inline void dodajNaPocetak(int vrednost) {
    pocetakReda = (pocetakReda + MAX_SIZE) % (MAX_SIZE + 1);
    red[pocetakReda] = vrednost;
}

inline void izbaciSaPocetka() {
    pocetakReda = (pocetakReda + 1) % (MAX_SIZE + 1);
}

inline void izbaciSaKraja() {
    krajReda = (krajReda + MAX_SIZE) % (MAX_SIZE + 1);
}

int main() {
    cin >> velicinaNiza >> vrednostModula;

    for (int i = 1; i <= velicinaNiza; i++) {
        cin >> vrednosti[i];
    }

    for (int mod = 1; mod <= vrednostModula; mod++) {
        int duzina = mod;

        for (int i = 1; i + duzina - 1 <= velicinaNiza; i++) {
            trenutniDp[i] = max(vrednosti[i], vrednosti[i + duzina - 1]);
        }

        for (duzina = mod + vrednostModula; duzina <= velicinaNiza; duzina += vrednostModula) {
            ocistiRed();

            for (int i = 1; i + duzina - vrednostModula - 1 <= velicinaNiza; i++) {
                while(pocetakReda != krajReda && trenutniDp[uzmiIzReda()] > trenutniDp[i])
                    izbaciSaPocetka();
                dodajNaPocetak(i);
                if(uzmiIzReda(false) <= i - vrednostModula)
                    izbaciSaKraja();
                minimalneVrednosti[i] = trenutniDp[uzmiIzReda(false)];
            }

            for (int i = 1; i + duzina - 1 <= velicinaNiza; i++) {
                int min1 = minimalneVrednosti[i + vrednostModula - 1];
                int min2 = minimalneVrednosti[i + vrednostModula];
                trenutniDp[i] = max(vrednosti[i] + min2, vrednosti[i + duzina - 1] + min1);
            }
        }

        duzina -= vrednostModula;
        int indeksRezultata = velicinaNiza + 1 - duzina;
        rezultati[indeksRezultata] = INT_MAX;

        for (int j = 1; j + duzina - 1 <= velicinaNiza; j++) {
            rezultati[indeksRezultata] = min(rezultati[indeksRezultata], trenutniDp[j]);
        }
    }

    for (int i = 1; i <= vrednostModula; i++) {
        cout << rezultati[i] << ' ';
    }
    cout << endl;

    return 0;
}