#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<vector<int>> trougli(n + 1, vector<int>(3));
    for(int i = 5; i <= n; i++) {
        for(int j = 0; j < 3; j++) {
            cin >> trougli[i][j];
        }
        sort(trougli[i].begin(), trougli[i].end());
    }

    vector<int> leviBrat(n + 1, -1), desniBrat(n + 1, -1);

    leviBrat[4] = 1;
    desniBrat[1] = 4;

    leviBrat[2] = 4;
    desniBrat[4] = 2;

    vector<vector<pair<pair<int, int>, int>>> kurac(n + 1);
    for(int i = 5; i <= n; i++) {
        int najveci = trougli[i].back();
        kurac[najveci].push_back({{trougli[i][0], trougli[i][1]}, i});
    }

    for(int i = 4; i <= n; i++) {
        if(kurac[i].empty()) {
            continue;
        }

        auto &braca = kurac[i];
        int xLevo = leviBrat[i];
        int xDesno = desniBrat[i];
        if(!braca.empty()) {
            auto &prviKurac = braca.front().first;
            if(prviKurac.first  == min(xLevo, xDesno) &&
               prviKurac.second == max(xLevo, xDesno)) {
                reverse(braca.begin(), braca.end());
            }
        }

        for(auto &conn: braca) {
            auto [xy, novaProdza] = conn;
            auto [x, y] = xy;

            if(leviBrat[x] == i) {
                leviBrat[x] = novaProdza;
                desniBrat[novaProdza] = x;
                leviBrat[novaProdza] = i;
                desniBrat[i] = novaProdza;
            } else if(desniBrat[x] == i) {
                desniBrat[x] = novaProdza;
                leviBrat[novaProdza] = x;
                desniBrat[novaProdza] = i;
                leviBrat[i] = novaProdza;
            } else if(leviBrat[y] == i) {
                leviBrat[y] = novaProdza;
                desniBrat[novaProdza] = y;
                leviBrat[novaProdza] = i;
                desniBrat[i] = novaProdza;
            } else if(desniBrat[y] == i) {
                desniBrat[y] = novaProdza;
                leviBrat[novaProdza] = y;
                desniBrat[novaProdza] = i;
                leviBrat[i] = novaProdza;
            } else {
                assert(false);
            }
        }
    }

    int start = 1;
    while(start != -1) {
        cout << start << " ";
        start = desniBrat[start];
    }

    cout << "3 1\n";

    return 0;
}