#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

// Funkcija za pronalaženje maksimalnog profita koji jedan brat može ostvariti
int maxProfit(int left, int right, vector<int>& nft) {
    if (left > right) 
        return 0; // Ako je niz prazno

    // Ako smo vec izracunali ovu kombinaciju, vratimo unap??? ?????????? ????????
    if (dp[left][right] != -1) 
        return dp[left][right]; 

    // Opcija uzimanja vrednosti sa pocetka niza
    int takeLeft = nft[left] + min(maxProfit(left + 2, right, nft), 
                                   maxProfit(left + 1, right - 1, nft));
    
    // Opcija uzimanja vrednosti sa kraja niza
    int takeRight = nft[right] + min(maxProfit(left + 1, right - 1, nft), 
                                     maxProfit(left, right - 2, nft));
    
    // Najbolji moguci izbor
    return dp[left][right] = max(takeLeft, takeRight);
}

int main() {
    int N, M;
    cin >> N >> M; // Unos broja NFT-ova i broja brace
    vector<int> nft(N);
    
    for (int i = 0; i < N; i++) {
        cin >> nft[i]; // Unos vrednosti svakog NFT-a
    }

    // Inicijalizacija memorije sa -1
    vector<vector<int>> dp(N, vector<int>(N, -1));

    // Izracunavanje maksimalnog profita
    int answer = maxProfit(0, N - 1, nft);
    cout << answer << endl; // Ispis rezultata

    return 0;
}